﻿---@type DP
local dp = _DP
---@type DPXGame
local dpx = _DPX

local game = require("df.game")
local logger = require("df.logger")
local luv = require("luv")
local world = require("df.game.mgr.world")

local item_handler = { }

------------------------------------ 以下代码是跨界石，不需要就删除---------------------------------- !
--[[
移动装备背包中的第1格道具至账号金库中, 若跨界失败则返还道具
仿照7576新建一个道具, 删除[string data]节, 以实现一个可以在城镇中使用后毫无效果的道具
]]
item_handler[1008611] = function(user, item_id)
    if not user:MoveToAccCargo(game.ItemSpace.INVENTORY, 9) then
        dpx.item.add(user.cptr, item_id)
    end
end



--[[
装备继承券
仿照7576新建一个道具, 删除[string data]节, 以实现一个可以在城镇中使用后毫无效果的道具
将装备背包中的第一格道具的强化/增幅继承到第二格道具上
]]
item_handler[1008612] = function(user, item_id)
    local mask = game.InheritMask.FLAG_UPGRADE | game.InheritMask.FLAG_AMPLIFY
    mask = mask | game.InheritMask.FLAG_MOVE_UPGRADE | game.InheritMask.FLAG_MOVE_AMPLIFY

    if not dpx.item.inherit(user.cptr, 9, 10, mask) then
        dpx.item.add(user.cptr, item_id)
    end
end


---------------------------------- 以下代码是修复绝望之塔卡金币异常，不需要就删除-------------------------------- !
local function MyUseAncientDungeonItems(next, _party, _dungeon, _item)
    local party = game.fac.party(_party)
    local dungeon = game.fac.dungeon(_dungeon)

    local dungeon_index = dungeon:GetIndex()
    if dungeon_index >= 11008 and dungeon_index <= 11107 then
        return true
    end

    return next()
end

----------------------------------- 副职业一键分解券 需要学习分解师副职不需要就删掉---------------------------------------
item_handler[1008613] = function(user, item_id)
    dpx.item.add(user.cptr, item_id)
    for i=9,100,1 do
        local info = dpx.item.info(user.cptr, game.ItemSpace.INVENTORY, i)
        if info then
            logger.info(string.format("will Disjoint [iteminfo] id: %d count: %d name: %s attach: %d", info.id, info.count, info.name, info.attach_type))
            user:Disjoint(game.ItemSpace.INVENTORY,i, user)
        end
    end
    user:SendItemSpace(game.ItemSpace.INVENTORY)
end

---------------------------------- 以下代码是城镇下线卡镇魂，不需要就删除-------------------------------- !
local my_save_town = function(_user, pre_town_id, post_town_id)
    if post_town_id == 13 then
        post_town_id = 11
    end

    return post_town_id
end

---------------------------------- 以下代码是开放极限祭坛，不需要就删除-------------------------------- !
local my_open_dungeon = function(next, dgn_idx)
    if (dgn_idx == 11007) then
        return true
    end

    return next(dgn_idx)
end

---------------------------------- 通用物品使用处理逻辑 -------------------------------- !
local my_useitem2 = function(_user, item_id)
    local user = game.fac.user(_user)
    local handler = item_handler[item_id]
    if handler then
        handler(user, item_id)
        logger.info("[useitem] acc: %d chr: %d item_id: %d", user:GetAccId(), user:GetCharacNo(), item_id)
    end
end

------------- 以下代码使用上方子程序功能的启动代码，不需要某个就删除--------------------- !
dpx.opt()
dpx.set_max_level(86)-- 设置服务端等级上限 !
dpx.disable_security_protection()-- 解除100级以及以上的限制 !
dpx.disable_item_routing()-- 史诗免确认提示框 !
dpx.disable_mobile_rewards()-- 新创建角色没有成长契约邮件 !
dpx.set_unlimit_towerofdespair()-- 绝望之塔通关后仍可继续挑战(需门票) !
dpx.disable_trade_limit()-- 解除交易限额(已经达到上限的第二天生效) !
dpx.enable_creator() -- 允许创建缔造者
dpx.hook(game.HookType.CParty_UseAncientDungeonItems, MyUseAncientDungeonItems)-- 修复绝望之塔金币提示异常 !
dpx.hook(game.HookType.CUser_SaveTown, my_save_town)-- 修复原始服务端补丁下线卡镇魂城镇 !
dpx.hook(game.HookType.UseItem2, my_useitem2)-- 跨界石、任务完成券、异界重置券、装备继承券、悬赏令任务hook !

logger.info("opt: %s", dpx.opt())
-- see dp2/lua/df/doc for document !
